/*=============================================================================
 * Luna Snippet: Adjust Visible and Max Save Files
//=============================================================================
/*:
 * @plugindesc <LunaSnippet_AdjustSave> v1.00 Adjust visible saves and max save slots.
 * @author Archeia
 *
 * @param Visible Saves
 * @desc Adjust Max Visisble Save Files.
 * @default 4
 *
 * @param Maximum Save Files
 * @desc Adjust Max Save Files.
 * @default 20
 *
 * @help BaseScript
 * 
*/

var Imported = Imported || {};
Imported.LunaSnippet_AdjustSave = true;

//=============================================================================
// ** Set Parameters
//=============================================================================
var LunaSnippet = LunaSnippet || {};
LunaSnippet.AdjustSave = LunaSnippet.AdjustSave || {};

//=============================================================================
// ** Parameter Check
//=============================================================================
var parameters = $plugins.filter(function(p) { return p.description.contains('<LunaSnippet_AdjustSave>') })[0].parameters;

//=============================================================================
// ** Parameters
//=============================================================================
LunaSnippet.AdjustSave.visibleSave = parseInt(parameters['Visible Saves'] || 4);
LunaSnippet.AdjustSave.maxSave = parseInt(parameters['Maximum Save Files'] || 20);

//==============================================================================
// Editting anything past this point may potentially result in causing
// computer damage, incontinence, explosion of user's head, coma, death, and/or
// halitosis so edit at your own risk.
//==============================================================================

//-----------------------------------------------------------------------------
// * Adjust Max Visisble Save Files
//-----------------------------------------------------------------------------
var lunaSnippet_maxVisibleItems = Window_SavefileList.prototype.maxVisibleItems
Window_SavefileList.prototype.maxVisibleItems = function() {
    lunaSnippet_maxVisibleItems.call(this);
    return LunaSnippet.AdjustSave.visibleSave;
};

//-----------------------------------------------------------------------------
// * Adjust Max Save Files
//-----------------------------------------------------------------------------
var lunaSnippet_maxSavefiles = DataManager.maxSavefiles
DataManager.maxSavefiles = function() {
    lunaSnippet_maxSavefiles.call(this);
    return LunaSnippet.AdjustSave.maxSave;
};
